from axelrod.action import Action, actions_to_str

from axelrod.player import Player

from axelrod.strategy_transformers import (
    FinalTransformer,
    TrackHistoryTransformer,
)

C, D = Action.C, Action.D

class SpitefulTitForTat(Player):
    """
    A player starts by cooperating and then mimics the previous action of the
    opponent until opponent defects twice in a row, at which point player
    always defects

    Names:

    - Spiteful Tit For Tat: [Prison1998]_
    """

    name = "Spiteful Tit For Tat"
    classifier = {
        "memory_depth": float("inf"),
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def __init__(self) -> None:
        super().__init__()
        self.retaliating = False

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        # First move
        if not self.history:
            return C

        if opponent.history[-2:] == [D, D]:
            self.retaliating = True

        if self.retaliating:
            return D
        else:
            # React to the opponent's last move
            if opponent.history[-1] == D:
                return D
            return C